using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a glowing ratman corpse" )]
	public class Yoggrath : BaseChampion
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.BleedAttack;
				case 1: return WeaponAbility.ArmorIgnore;
				case 2: return WeaponAbility.MortalStrike;
			}
		}

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public Yoggrath() : this (false, 6)
		{
		}

		[Constructable]
		public Yoggrath(int range) : this (false, range)
		{
		}

		[Constructable]
		public Yoggrath(bool ischampion, int range) : base(AIType.AI_Mage, FightMode.Closest, ischampion, range)
		{
			Name = "Yoggrath";
			Body = 150;
			BaseSoundID = 447;
			Hue = 1487;

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetInt(1000, 1200);

			SetHits(50000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 35);

			SetDamageType(ResistanceType.Energy, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 70, 75);
			SetResistance(ResistanceType.Fire, 100);
			SetResistance(ResistanceType.Cold, 100);
			SetResistance(ResistanceType.Poison, 70, 75);
			SetResistance(ResistanceType.Energy, 70, 75);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;
			CanSwim = true;

			DropMin = 30;
			DropMax = 80;
			DropType = ChampDrop.Gold;
			BonusLoot = "tokens";
			BonusLootAmount = Utility.RandomMinMax(15, 30);

			PackItem(new Navnada(Utility.RandomMinMax(3, 10)));

			if(0.01 > Utility.RandomDouble())
				PackItem(ClothingSkillScroll.CreateRandomNoCraft(1, Utility.RandomList(1, 1, 1, 1, 1, 1, 2, 2, 3)));

			if(0.5 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)]));

			PackItem(new MessageInABottle());
			PackItem(new SpecialFishingNet()); //Confirm?
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			from.Stam -= Utility.Random(5, 15);
			from.Mana -= Utility.Random(6, 15);

			if (Utility.RandomDouble() < 0.025)
			{
				LysanderGathenwale.SummoningRing(this, typeof(WaterElemental));
				Server.Regions.KhaldunRegion.DropHealthOrb(this);
			}

			if (Utility.RandomDouble() < 0.1)
				Utilitky.CorpseExplosion(from, this);

			if (Utility.RandomDouble() < 0.015 && this.Hits < (this.HitsMax * 70) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();

				vortex.ItemID = 13807;
				vortex.Hue = 0;
				vortex.Name = "crystal brazier";
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
			}
		}

		public override int Meat { get { return 10; } }
		public override int Hides { get { return 250; } }
		public override ScaleType ScaleType { get { return ScaleType.Blue; } }
		public override int Scales { get { return 20; } }
		public override HideType HideType { get { return HideType.Horned; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool CanRummageCorpses { get { return false; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp      
      public override bool IsScaryToPets { get { return true; } }
		public override bool AlwaysMurderer { get { return true; } }

		public override bool HasBreath { get { return true; } }
		public override int BreathPhysicalDamage { get { return 20; } } // TODO: Verify damage type
		public override int BreathColdDamage { get { return 80; } }
		public override int BreathFireDamage { get { return 0; } }
		public override int BreathEffectHue { get { return 0x1ED; } }
		public override double BreathDamageScalar { get { return 0.05; } }
		public override double BreathMinDelay { get { return 5.0; } }
		public override double BreathMaxDelay { get { return 7.5; } }

		public override bool HasAOEBreath { get { return true; } }
		public override string AOEBreathName { get { return "ice storm"; } }
		public override int AOEBreathRadius { get { return 4; } }
		public override int AOEBreathDuration { get { return 2; } }
		public override int AOEBreathEffectItemID { get { return 0x376A; } }
		public override int AOEBreathEffectHue { get { return 1154; } }

		public override void AOESpecialEffect(Mobile m)
		{
			int duration = 6;
			if (m.ColdResistance > Utility.Random(50) + 40)
				duration = 4;

			m.Freeze(TimeSpan.FromSeconds(duration));
			m.SendMessage("You are chilled to the bones.");
			//             m.HueMod = 1153;
			//             Timer.DelayCall(TimeSpan.FromSeconds(duration), new TimerStateCallback(m_RestoreHue), m);
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob == null)
				return;

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public Yoggrath(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}